<?php
/**
 * @file
 * facebook_embed.admin.inc
 * Settings form for global facebook_embed custimazation.
 */

/**
 * Returns settings form for facebook_embed.
 */
function facebook_embed_admin_settings_form($form, &$form_state) {
  $languages = language_list();

  $form = array();

  $form['facebook_embed_languages'] = array(
    '#type' => 'fieldset',
    '#title' => t('Languages mapping'),
    '#description' => t('Remember: You need to enable the input filter in your text format to get this module working.'),
  );

  foreach ($languages as $language) {
    $form['facebook_embed_languages']['facebook_embed_language_' . $language->language] = array(
      '#type' => 'select',
      '#title' => t('Mapping for @language_name (@language_language)', array('@language_name' => $language->name, '@language_language' => $language->language)),
      '#description' => t('Select the equivalent language code in the facebook locale'),
      '#default_value' => variable_get('facebook_embed_language_' . $language->language, 'en_US'),
      '#options' => _facebook_embed_get_facebook_locale(),
    );
  }

  $form = system_settings_form($form);
  return $form;
}

/**
 * Function to fetch supported locale by facebook.
 */
function _facebook_embed_get_facebook_locale() {
  $fb_locale = array();
  $cache = cache_get('facebook_embed');
  if (empty($cache->data)) {
    $result = drupal_http_request("https://www.facebook.com/translations/FacebookLocales.xml");
    if ($result->code == 200) {
      $xml = simplexml_load_string($result->data);
      foreach ($xml->locale as $line) {
        $representation = ( array ) $line->codes->code->standard->representation;
        $name = ( array ) $line->englishName;
        $key = $representation[0];
        $value = $name[0];
        $fb_locale[$key] = $value;
      }
      cache_set('facebook_embed', serialize($fb_locale), 'cache');
    }
    else {
      drupal_set_message(t("There was an issue with fetching Facebooks locales. Please try again later."), 'error');
    }
  }
  else {
    $fb_locale = unserialize($cache->data);
  }
  return $fb_locale;
}
